using System;
using System.Collections;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write(string.Format("{0}", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage)));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
		   try
		   {
            CPDF pdf = new CPDF();
            pdf.SetOnErrorProc(IntPtr.Zero, new TErrorProc(PDFError));

            pdf.CreateNewPDF(null);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               String text = "Some text on a page...";
               pdf.SetFont("Helvetica", TFStyle.fsRegular, 20.0, false, TCodepage.cp1252);

               double d = pdf.GetDescent();
               double w = pdf.GetTextWidth(text);

               pdf.WriteText(50.0, 50.0, text);
               pdf.HighlightAnnot(TAnnotType.atHighlight, 50.0, 50.0 + d, w, 20.0, CPDF.PDF_YELLOW, "Test app", "Highligh Annotations", "This is a highlight annotation");

               pdf.WriteText(50.0, 80.0, text);
               pdf.HighlightAnnot(TAnnotType.atSquiggly, 50.0, 80.0 + d, w, 20.0, CPDF.PDF_RED, "Test app", "Squiggly Annotations", "This is a squiggly annotation");

               pdf.WriteText(50.0, 110.0, text);
               pdf.HighlightAnnot(TAnnotType.atStrikeOut, 50.0, 110.0 + d, w, 20.0, CPDF.PDF_RED, "Test app", "Strikeout Annotations", "This is a strikeout annotation");

               pdf.WriteText(50.0, 140.0, text);
               pdf.HighlightAnnot(TAnnotType.atUnderline, 50.0, 140.0 + d, w, 20.0, CPDF.PDF_RED, "Test app", "Underline Annotations", "This is a underline annotation");
            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
